/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.support;

import com.floragunn.codova.validation.errors.ValidationError;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.logging.log4j.util.Strings;
import org.elasticsearch.script.ScriptException;

public class ScriptValidationError
extends ValidationError {
    private String context;

    public ScriptValidationError(String attribute, ScriptException scriptException) {
        super(attribute, ScriptValidationError.getMessage(scriptException));
        this.cause(scriptException);
        if (scriptException.getScriptStack() != null && scriptException.getScriptStack().size() > 0) {
            this.context = Strings.join((Iterable)scriptException.getScriptStack(), (char)'\n');
        }
    }

    public Map<String, Object> toBasicObject() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("error", this.getMessage());
        if (this.context != null) {
            result.put("context", this.context);
        }
        return result;
    }

    private static String getMessage(ScriptException scriptException) {
        if ("compile error".equals(scriptException.getMessage())) {
            if (scriptException.getCause() != null) {
                return scriptException.getCause().getMessage();
            }
            return "Compilation Error";
        }
        return scriptException.getMessage();
    }
}

